<?php
	header('X-Frame-Options: DENY');
	header('X-XSS-Protection: 1; mode=block');
	header('Content-Type: text/html; charset=utf-8');

	include('../../../inc/db.php');
	include('../../../inc/functions.php');
	include('../../../inc/classes/class.template.php');

	$start = isset($_POST['start']) ? intval($_POST['start']) : 0;
	$limit = isset($_POST['limit']) ? intval($_POST['limit']) : 1;
	$class = isset($_POST['class']) ? intval($_POST['class']) : 0;

	$start = $start > 0 ? $start : 0;
	$limit = $limit > 0 ? $limit : 1;
	$class = $class ? 'AND `class`="'.$class.'"' : '';

	$tpl = new Template;
	$tpl->dir = '../tpl/ajax/';

	$date = date('Y-m-d H:i:s');

	$query = $pdo->query('SELECT `id`, `new_name`, `img`, `short_text`, `date`, `views` FROM `news` WHERE `date`<"'.$date.'" '.$class.' ORDER BY `date` DESC LIMIT '.$start.', '.$limit);
			 $query->setFetchMode(PDO::FETCH_OBJ);

	$tpl->result['content'] = '';

	while($news = $query->fetch())
	{
		$tpl->load_template('news.tpl');
			$tpl->set('{id}', $news->id);
			$tpl->set('{title}', $news->new_name);
			$tpl->set('{poster}', $news->img);
			$tpl->set('{text}', $news->short_text);
			$tpl->set('{date}', expand_date($news->date, 3).' - '.expand_date($news->date, 0));
			$tpl->set('{views}', $news->views);
		$tpl->compile('content');
	}

	echo $tpl->result['content'];
?>